<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <script src="https://kit.fontawesome.com/90b556f99d.js" crossorigin="anonymous"></script>
    <link href="https://fonts.googleapis.com/css2?family=Nova+Square&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="shortcut icon" href="img/favicon.webp">
    <title>Accueil</title>
</head>
<body>
    <section class="header">
            <nav class="navbar">
                    <li class="logo"><a href="index.php" class="logo"><img src="img/Resa.png" alt="acceuil RésaKingdom"></a></li>
                        <div class="bordureShearch flexCentre">
                    <div class="nav-links">
                        <ul>
                        <li><a href="#" alt="Accueil RésaKingdom" class="active">Accueil</a></li>
                        <li><a href="destination.php">Réserver</a></li>
                        </ul>
            </nav>
            <div class="sombre">
                <h1>Partez à la découverte des royaumes !!!</h1>
                <h2>Allez <span class="auto-typing"></span></h2>
            </div>
    </section>

    <section class="decouvrir" id="decouvrir">
            
        <div class="txt_presentation" data-aos="fade-up">
            <h2>Avec RésaKingdom, découvrez ou redécouvrez les mondes de la saga kingdom hearts!</h2>
            <p>Grâce à notre technologie Gummi dernière génération, nous pouvons vous emmener là où votre coeur le désir et ceux en un temps record garantie sans sans-cœur et TOTALEMENT GRATUIT ! Alors qu’attendez-vous ? Faites le bon choix et choisissez ResaKingdom !</p>
            <span>May your heart be your guiding key.</span>
        </div>
        
        <img src="img/gummi.webp" alt="" class="gummi" data-aos="fade-down">

        </section>

        <section class="slider-container" id="slider">
        <h2 data-aos="fade-up">Découvrez des lieux merveilleux et Mistèrieux</h2>
        <div class="js-slider" data-aos="flip-left">
            <div class="js-photos">
                <div class="js-photo green-darker clone">
                
                </div>
                <div class="js-photo green">
                
                </div>
                <div class="js-photo green-dark">
                
                </div>
                <div class="js-photo green-darker">
                    
                </div>
                <div class="js-photo green clone">
                
                </div>
            </div>
            <div class="js-navigation">
                <button class="js-btn-decale-droite">
                    <span class="arrow"><</span>
                </button>
                <button class="js-btn-decale-gauche">
                    <span class="arrow">></span>
                </button>
            </div>
    </div>
    </section>


    <section class="destination" id="destination">
        <h2 data-aos="fade-up">Nos Magnifiques Destinations</h2>
        <div class="destcontainer">
                <?php
                    include 'conn.php';
                    $requete="SELECT * FROM rek_destination ORDER BY id_destination DESC LIMIT 3";
                    $stmt=$db->query($requete);
                    $result=$stmt->fetchall(PDO::FETCH_ASSOC);

                    foreach ($result as $destination){
                    echo "<div class='boite' data-aos='flip-right'>";
                    echo "<h3>{$destination["nom"]}</h3>";
                    echo "<a href='reserv.php?id=" . $destination['id_destination'] . "'>";
                    echo "<img src='{$destination["img"]}' alt='image d'illustration de la destination'>";
                    echo "</a>";
                    echo "</div>";  
                    }
                ?>
        </div>
    </section>

        <section class="section_btn"><a href="destination.php" class="btn">Tout voir</a></section>

   <footer>
         <a href="a_propos.html">A propos</a> <br>
        <p>Site édité par Colheen NKODIA-DIABATÉ (cnkodiadiabate@edu.univ-eiffel.fr) dans le cadre de la SAE 2.03 © Colheen NKODIA-DIABATÉ, 2024. Héberger sur O2switch</p>
    </footer>
    
    <div class="overlay"></div>
    </div>


    <script src="script.js"></script>
    <script src="https://unpkg.com/typed.js@2.1.0/dist/typed.umd.js"></script>
    <script>
    <!--1b-->
        let typed = new Typed('.auto-typing', {
            strings: ['aux Iles du destin','à la Cité du Crépuscule', 'au Chateau Disney', 'au Colisée de L\'Olympe', 'au Jardin Radieux', 'à la Ville de Traverse',],
            typeSpeed: 100,
            backSpeed: 100,
            loop: true,
            fadeOut: true,
            fadeOutClass: 'typed-fade-out',
            fadeOutDelay: 500,
            shuffle: true
        })
    </script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init();
    </script>
</body>
</html>