<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/expo/css/style.css">
    <link rel="shortcut icon" href="/expo/img/logo.svg" type="image/svg">
    <link href="https://fonts.googleapis.com/css2?family=Courier+Prime:wght@400;700&display=swap" rel="stylesheet">
    <title>Expo-Elizebeth_Friedman BackOffice-utilisateurs</title>
</head>
<?php
if (!isset($_SESSION['login']) || $_SESSION['user_id'] != 1) {
    echo "Vous ne pouvez pas accéder à cette page, car vous n'êtes pas administrateur.";
    var_dump($_SESSION);
    exit;
}
?>
<body>
<header>
    <nav>
        <div class="link_group">
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=deconn">Déconnexion</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=ticket">tickets</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=stat">statistiques</a>
        </div>
        <img src="/expo/img/logo.svg" alt="logo">
        <button><a href="english/index.php?action=user">EN</a></button>
    </nav>
</header>
<main>
    <h1>👥 Page Utilisateurs</h1>

    <p>La page Utilisateurs recense l’ensemble des membres inscrits sur la plateforme. Elle permet de consulter les profils, de gérer les informations des utilisateurs et de suivre leur historique de réservations.</p>

    <table width="100%" border="1" cellspacing="0" cellpadding="8" align="center" style="border-collapse: collapse;">
                <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>Email</th>
                    <th>Supprimer</th>
                </tr>
<?php
$ch = curl_init("https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=user");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true) ?? [];

if (!isset($data['status'])) {
    echo "<p>Erreur : Réponse invalide du serveur</p>";
    exit;
}

if ($data['status'] === 200 && isset($data['users'])) {
    foreach ($data['users'] as $user) {
            echo '
                <tr align="center">
                    <td>' . $user['id'] . '</td>
                    <td>' . $user['nom'] . '</td>
                    <td>' . $user['prenom'] . '</td>
                    <td>' . $user['email'] . '</td>
                    <td>
                        <button class="bouton" onclick="deleteUser(' . $user['id'] . ')" style="cursor: pointer;" >Supprimer</button>
                    </td>
                </tr>
';
    }
} else {
    echo "<p>Erreur : {$data['message']}</p>";
}
?>
</table>
</main>
<script>
    function deleteUser(id) {
    fetch(`https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=supr_user&id=${id}`, {
        method: "DELETE"
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        location.reload();
    })
    .catch(error => console.error("Erreur :", error));
}
</script>
</body>
</html>
