<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/expo/css/style.css">
    <link rel="shortcut icon" href="/expo/img/logo.svg" type="image/svg">
    <link href="https://fonts.googleapis.com/css2?family=Courier+Prime:wght@400;700&display=swap" rel="stylesheet">
    <title>Expo-Elizebeth_Friedman Réservation</title>
</head>
<body>
    <header>
        <nav>
            <img src="/expo/img/logo.svg" alt="logo">
            <div class="link_group">
                <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=deconn">Déconnexion</a></a>
                <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=profil">Profil</a>
            </div>
            <button><a href="english/index.php?action=booking">EN</a></button>
        </nav>
    </header>
<main>
<?php
    if (!isset($_SESSION['user_id'])) {
        echo "<p class='error-message'>Vous devez être connecté pour réserver une séance. <a href='index.php?action=connexion'>Connectez-vous</a>.</p>";
        exit;
    }
?>

    <h1>Réservez</h1>

    <p>Les séances sont gratuites, l'heure et la date de la séance sont à réserver. Un lien vous sera envoyé par mail afin d'y accéder.</p>

<div class="form-container">
    <form method="POST">
        <h2></h2>
        <p>Tous les champs sont obligatoire</p>
    <?php
echo "
    <input type='hidden' name='expo_id' value='1'>
    <input type='hidden' name='user_id' value='".$_SESSION['user_id']."'>
    
    <div class='input-group'>
        <label>Quelle heure ?</label>
        <div class='heure-buttons'>
            <input type='radio' id='heure-09' name='heure' value='09:00' required>
            <label for='heure-09' class='heure-bouton'>09:00</label>

            <input type='radio' id='heure-11' name='heure' value='11:00' required>
            <label for='heure-11' class='heure-bouton'>11:00</label>

            <input type='radio' id='heure-13' name='heure' value='13:00' required>
            <label for='heure-13' class='heure-bouton'>13:00</label>

            <input type='radio' id='heure-15' name='heure' value='15:00' required>
            <label for='heure-15' class='heure-bouton'>15:00</label>

            <input type='radio' id='heure-18' name='heure' value='18:00' required>
            <label for='heure-18' class='heure-bouton'>18:00</label>
        </div>
    </div>  

    <div class='input-group'>
        <label for='nb_ticket'>Combien de personnes ?</label>   
        <select id='nb_ticket' name='nb_ticket' required>
            <option value='1'>1</option>
            <option value='2'>2</option>
            <option value='3'>3</option>
            <option value='4'>4</option>
            <option value='5'>5</option>
            <option value='6'>6</option>
            <option value='7'>7</option>
            <option value='8'>8</option>
            <option value='9'>9</option>
            <option value='10'>10</option>
        </select> 
    </div>

    <div class='input-group'>
        <label for='date'>Quelle date ?</label>
        <input type='date' id='date' name='date' min='2025-03-26' max='2025-04-26'>
    </div>

    <input type='submit' value='Réserver' class='bouton'>
";
?>
    </form>
</div>
<?php
//ajout d'un ticket de réservation
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $postData = [
        'expo_id' => $_POST['expo_id'],
        'user_id' => $_POST['user_id'],
        'heure' => $_POST['heure'],
        'nb_ticket' => $_POST['nb_ticket'],
        'date' => $_POST['date']
    ]; 
       $ch = curl_init("https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=add_ticket");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true) ?? [];
    if (isset($data['message'])) {
        echo "<p>{$data['message']}</p>";
    } else {
        echo "<p>Erreur : Aucune réponse 'message' de l'API</p>";
    }
}

//envoie du mail
if (isset($data['message'])) {
    echo "<p>{$data['message']}</p>";

    $to = $_SESSION['login'];
    $subject = "Confirmation de réservation - Exposition - Casser les codes";
    $message = "
        Bonjour,

        Votre réservation pour l'exposition 'Casser les codes' a été confirmée.

        Détails :
        - Date : {$_POST['date']}
        - Heure : {$_POST['heure']}
        - Nombre de tickets : {$_POST['nb_ticket']}

        Vous recevrez un lien par email avant la séance.

        Merci pour votre réservation !

        Cordialement,
        L'équipe de Odyssée.
    ";
    $headers = "From: no-reply@exposition.com\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    if (mail($to, $subject, $message, $headers)) {
        echo "<p>Un email de confirmation a été envoyé.</p>";
    } else {
        echo "<p>Erreur : Impossible d'envoyer l'email.</p>";
    }
}
?>
</main>
</body>
</html>