<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/expo/css/style.css">
    <link rel="shortcut icon" href="/expo/img/logo.svg" type="image/svg">
    <title>Expo-Elizebeth_Friedman BackOffice-tickets</title>
</head>
<?php
if (!isset($_SESSION['login']) || $_SESSION['user_id'] != 1) {
    echo "You cannot access this page because you are not an administrator.";
    var_dump($_SESSION);
    exit;
}
?>
<body>
<header>
    <nav>
        <div class="link_group">
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/english/index.php?action=logout">Log out</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/english/index.php?action=user">Users</a>
            <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/english/index.php?action=stat">Statistics</a>
        </div>
        <img src="../img/logo.svg" alt="">
        <button><a href="../index.php?action=ticket">FR</a></button>
    </nav>
</header>
<main>
    
<h1>🎟 Tickets Page</h1>

<p>The Tickets Page centralizes all reservations made by users. It allows access to ticket details, tracking of reservation status, and making modifications if necessary.</p>

<div class="table-contaier">
    <table width="100%" border="1" cellspacing="0" cellpadding="8" align="center" style="border-collapse: collapse;">
            <thead>
                <tr align='center'>
                    <th>ID</th>
                    <th>Email</th>
                    <th>Exhibition</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>Number of tickets</th>
                    <th>Delete</th>
                </tr>
            </thead>
<?php
$ch = curl_init("https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=ticket");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true) ?? [];

if (!isset($data['status'])) {
    echo "<p>Erreur : Réponse invalide du serveur</p>";
    exit;
}

if ($data['status'] === 200 && isset($data['tickets'])) {
    foreach ($data['tickets'] as $ticket) {
        echo "
        <tbody>
            <tr align='center'>
                <td>{$ticket['id']}</td>
                <td>{$ticket['user_email']}</td> 
                <td>{$ticket['expo_nom']}</td>
                <td>{$ticket['date']}</td>
                <td>{$ticket['heure']}</td>
                <td>{$ticket['nb_ticket']}</td>
                <td><button onclick='deleteTicket({$ticket['id']})' class='bouton'>Delete</button></td>
            </tr>
        </tbody>
        ";
    }
} else {
    echo "<p>Erreur : {$data['message']}</p>";
}
?>
    </table>
</div>
</main>
<script>
    function deleteTicket(id) {
    fetch(`https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=supr_ticket&id=${id}`, {
        method: "DELETE"
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        location.reload();
    })
    .catch(error => console.error("Erreur :", error));
}
</script>
</body>
</html>
