<?php

require 'config_api.php';
require 'function.php';


$action = isset($_GET['action']) ? $_GET['action'] : null;

if (!$action) {
    echo json_encode(["status" => 400, "message" => "Aucune action spécifiée"]);
    exit;
}

session_start();

switch ($action) {

//Connexion

    case 'login' :
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            login($pdo);
        }
        break;

//Utilisateurs 

        //voir les utilisateurs
    case 'user' : 
        if ($_SERVER['REQUEST_METHOD'] == 'GET'){
            if(isset($_GET['id'])){
                user($pdo);     
            }else{
                all_user($pdo);
            }
        }
        break;

        //ajouter un utilisateur
    case 'add_user': 
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            add_user($pdo);
        }
        break;

        //supprimer un utilisateur
    case 'supr_user':
        if ($_SERVER['REQUEST_METHOD'] == 'DELETE'){
            supr_user($pdo);
        }
        break;

        //modifier un utilisateur
    case 'modify_user':
        if ($_SERVER['REQUEST_METHOD'] == 'PUT'){
            modify_user($pdo);
        }
        break;

//Tickets de réservation

        //voir les tickets
    case 'ticket' :
        if ($_SERVER['REQUEST_METHOD'] == 'GET'){
            if(isset($_GET['id'])){
                ticket($pdo);
            }elseif(isset($_GET['user_id'])){
                ticket_byUser($pdo);
            }else{
                all_tickets($pdo);
            }}
        break;

        //ajouter un ticket de réservation
    case 'add_ticket': 
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            add_ticket($pdo);
        }
        break;

        //supprimer un ticket de réservation
    case 'supr_ticket':
        if ($_SERVER['REQUEST_METHOD'] == 'DELETE'){
            supr_ticket($pdo);
        }
        break;

        //modifier les Tickets de réservations
    case 'modify_ticket':
        if ($_SERVER['REQUEST_METHOD'] == 'PUT'){
            modify_ticket($pdo);
        }
        break;
//Action incorrecte 

    default:
        echo json_encode(["status" => 400, "message" => "Action inconnue"]);
        break;
}
//Fermeteur de la base de donnée
$pdo = null;
?>
