<?php

//Fonctions 

//Fonction de connexion

function login($pdo) {
    $email = $_POST["email"] ?? null;
    $mdp = $_POST["mdp"] ?? null;

    if (!$email || !$mdp) {
        echo json_encode(["status" => 400, "message" => "Email et mot de passe requis"]);
        exit;
    }

    $stmt = $pdo->prepare("SELECT * FROM user WHERE email = :email");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($mdp, $user['mdp'])) {
        $_SESSION["login"] = $user['email'];
        $_SESSION["nom"] = $user['nom'];
        $_SESSION["prenom"] = $user['prenom'];
        $_SESSION["user_id"] = $user['id'];

        echo json_encode(["status" => 200, "message" => "Connexion réussie", "id_user" => $user['id'], "nom" => $user['nom'], "prenom" => $user['prenom']]);
    } else {
        echo json_encode(["status" => 300, "message" => "Email ou mot de passe incorrect"]);
    }
}

//Fonction des tickets de reservation 

//Ticket par ID
function ticket($pdo) {
    if (isset($_GET['id'])) {
        $ticket_id = $_GET['id'];
        $stmt = $pdo->prepare("SELECT * FROM ticket WHERE id = :id");
        $stmt->execute(['id' => $ticket_id]);
        $ticket = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($ticket) {
            echo json_encode([
                "status" => 200,
                "message" => "Ticket trouvé",
                "ticket" => $ticket
            ]);
        } else {
            echo json_encode([
                "status" => 300,
                "message" => "Ticket non trouvé"
            ]);
        }
    } else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre 'id' manquant"
        ]);
    }
}

//Tous les tickets par utilisateurs
function ticket_byUser($pdo) {
    if (isset($_GET['user_id'])) {
        $ticket_id = $_GET['user_id'];
        
        $stmt = $pdo->prepare("SELECT 
            ticket.id AS id,
            ticket.user_id, 
            user.email AS user_email, 
            exposition.nom AS expo_nom, 
            ticket.date, ticket.heure, ticket.nb_ticket
        FROM ticket
        JOIN user ON ticket.user_id = user.id
        JOIN exposition ON ticket.expo_id = exposition.id
        WHERE ticket.user_id = :user_id");
        
        $stmt->execute(['user_id' => $ticket_id]);
        $tickets = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($tickets) {
            echo json_encode([
                "status" => 200,
                "message" => "Ticket(s) trouvé(s)",
                "tickets" => $tickets
            ]);
        } else {
            echo json_encode([
                "status" => 300,
                "message" => "Aucun ticket trouvé"
            ]);
        }
    } else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre 'user_id' manquant"
        ]);
    }
}


//Tous les Tickets
function all_tickets($pdo) {
    $stmt = $pdo->prepare("SELECT 
            ticket.id, 
            user.email AS user_email, 
            exposition.nom AS expo_nom, 
            ticket.date, ticket.heure, ticket.nb_ticket
        FROM ticket
        JOIN user ON ticket.user_id = user.id
        JOIN exposition ON ticket.expo_id = exposition.id");
    $stmt->execute();
    $tickets = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => 200,
        "message" => "Tickets récupérés",
        "tickets" => $tickets 
    ]);
}

//ajouter un ticket de réservation 
function add_ticket($pdo){
    if (!empty($_POST['user_id']) && !empty($_POST['expo_id']) && !empty($_POST['date']) && !empty($_POST['heure']) && !empty($_POST['nb_ticket'])) {

        $user_id = $_POST['user_id'];
        $expo_id = $_POST['expo_id'];
        $date = $_POST['date'];
        $heure = $_POST['heure'];
        $nb_ticket = $_POST['nb_ticket'];

        $stmt = $pdo->prepare("INSERT INTO ticket (user_id, expo_id, date, heure, nb_ticket) VALUES (:user_id, :expo_id, :date, :heure, :nb_ticket)");
        $stmt->execute([
            'user_id' => $user_id,
            'expo_id' => $expo_id,
            'date' => $date,
            'heure' => $heure,
            'nb_ticket' => $nb_ticket
        ]);

        echo json_encode([
            "status" => 200,
            "message" => "Ticket de réservation ajouté",
        ]);
    } else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre manquant",
        ]);
    }
}

//Supprimer les tickets de réservations 
function supr_ticket($pdo){
    if(isset($_GET['id'])){
        $ticket_id = $_GET['id'];
        $stmt = $pdo->prepare("DELETE FROM ticket WHERE id = :id");
        $stmt->execute([':id' => $ticket_id]);

        echo json_encode([
            "status" => 200,
            "message" => "Ticket de réservation suprimmé",
        ]);
    }else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre 'ID' manquant",
        ]);
    }
}

//Modifier les tickets de réservations
function modify_ticket($pdo){
    $inputData = json_decode(file_get_contents("php://input"), true);

    if (!empty($inputData['id']) && !empty($inputData['expo_id']) && !empty($inputData['user_id']) && !empty($inputData['date'])) {

        $ticket_id = $inputData['id'];
        $expo_id = $inputData['expo_id'];
        $user_id = $inputData['user_id'];
        $date = $inputData['date'];

        $stmt = $pdo->prepare("UPDATE ticket SET expo_id = :expo_id, user_id = :user_id, date = :date WHERE id = :id");
        $stmt->execute([
            ':id' => $ticket_id,
            ':expo_id' => $expo_id,
            ':user_id' => $user_id,
            ':date' => $date,
        ]);

        echo json_encode([
            "status" => 200,
            "message" => "Ticket modifié",
        ]);
    }else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètres manquants",
        ]);
    }
}

// Fonctions des utilisateurs

//Utilisateur par ID
function user($pdo){
    if (isset($_GET['id'])){
        $user_id = $_GET['id'];
        $stmt = $pdo->prepare("SELECT * FROM user WHERE id = :id");
        $stmt->execute(['id' => $user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            echo json_encode([
                "status" => 200,
                "message" => "Utilisateur trouvé",
                "user" => $user
            ]);
        } else {
            echo json_encode([
                "status" => 300,
                "message" => "Utilisateur non trouvé"
            ]);
        }
    } else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre 'id' manquant"
        ]);
    }

    }

//Tous les Utilisateur
function all_user($pdo){
    $stmt = $pdo->prepare("SELECT * FROM user");
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => 200,
        "message" => "Utilisateurs récupérés",
        "users" => $users
    ]);
}

//Ajout d'utilisateur
function add_user($pdo){
    if (!empty($_POST['nom']) && !empty($_POST['prenom']) && !empty($_POST['email']) && !empty($_POST['mdp'])) {

        $nom = $_POST['nom'];
        $prenom = $_POST['prenom'];
        $email = $_POST['email'];
        $mdp = password_hash($_POST['mdp'], PASSWORD_DEFAULT);

        $stmt = $pdo->prepare("INSERT INTO user (nom, prenom, email, mdp) VALUES (:nom, :prenom, :email, :mdp)");
        $stmt->execute(['nom' => $nom, 'prenom' => $prenom, 'email' => $email, 'mdp' => $mdp]);

        echo json_encode([
            "status" => 200,
            "message" => "Utilisateurs ajouté recharger la page pour voir le nouvel utilisateur",
        ]);
    }else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre manquant",
        ]);
    }
}

//Supprimer les utilisateurs 
function supr_user($pdo){
    if(isset($_GET['id'])){
        if ($_GET['id'] == 1) {
            echo json_encode([
                "status" => 300,
                "message" => "Vous ne pouvez pas supprimer l'administrateur !",
            ]);
        }else{
            $user_id = $_GET['id'];
            $stmt = $pdo->prepare("DELETE FROM user WHERE id = :id");
            $stmt->execute([':id' => $user_id]);
    
            echo json_encode([
                "status" => 200,
                "message" => "Utilisateur suprimmé",
            ]);
        }
    }else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètre 'ID' manquant",
        ]);
    }
}

// Modifier un utilisateur
function modify_user($pdo){
    $inputData = json_decode(file_get_contents("php://input"), true);

    if (!empty($inputData['user_id']) && !empty($inputData['nom']) && !empty($inputData['prenom']) && !empty($inputData['email']) && !empty($inputData['mdp'])) {

        $user_id = $inputData['user_id'];
        $nom = $inputData['nom'];
        $prenom = $inputData['prenom'];
        $email = $inputData['email'];
        $mdp = password_hash($inputData['mdp'], PASSWORD_DEFAULT);

        $stmt = $pdo->prepare("UPDATE user SET nom = :nom, prenom = :prenom, email = :email, mdp = :mdp WHERE id = :id");
        $stmt->execute([
            ':id' => $user_id,
            ':nom' => $nom,
            ':prenom' => $prenom,
            ':email' => $email,
            ':mdp' => $mdp
        ]);

        echo json_encode([
            "status" => 200,
            "message" => "Utilisateur modifié",
        ]);
    } else {
        echo json_encode([
            "status" => 400,
            "message" => "Paramètres manquants",
        ]);
    }
}
?>