<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../styles/back.css">
    <link rel="icon" type="image/jpg" href="../img/logo.png">
    <title>Back-Office</title>
</head>
<body>
    <h1>Liste des personnages</h1>

    <div class='music-control'>
    <audio src="../music/Aria Of Soul_back.mp3" id='audio' loop></audio>
        <h3>Musique de l'écran de liste</h3>
        <a href="javascript:void(0)" onclick=changeState(0) class='btn'>Play</a>
        <a href="javascript:void(0)" onclick=changeState(1) class='btn'>Pause</a>
        <a href="javascript:void(0)" onclick=changeState(2) class='btn active'>Stop</a>
    </div>

<?php

require_once '../autoload.php';

$personnages = $monManager->getAllPersonnages();

foreach($personnages as $perso){
    echo"
   <table border='1'>
    <form action='index.php?action=modif' method='POST'>
        <tr>
            <th><label for='nom'>Nom</label></th>
            <th><label for='hp'>HP</label></th>
            <th><label for='atk'>ATK</label></th>
            <th><label for='def'>DEF</label></th>
            <th><label for='image'>Image</label></th>
            <th>Suppr</th>
            <th>Modif</th>
        </tr>
        <tr>
            <input type='hidden' name='id' id='id' value=".$perso->getId().">
            <td><input type='text' name='name' id='name' maxlength='20' value=".$perso->getName()."></td>
            <td><input type='number' name='hp' id='hp' value= ".$perso->getHp()."></td>
            <td><input type='number' name='atk' id='atk' value=".$perso->getAtk()."></td>
            <td><input type='number' name='def' id='def' value=".$perso->getDef()."></td>
            <td><img src='../img/".$perso->getImage()."' alt='image de ".$perso->getName()."' width='100px' height='100px'></td>
            <td><a href='index.php?action=suppr&id=".$perso->getId()."'>Supprimer le perso</a></td>
            <td><input type='submit' value='Modifier le perso'><td>
        </tr>
    </form>
</table>
    ";
}

echo "
<br><br>
<h2>Créer un personnage !<h2>

<form action='index.php?action=add' method='POST' enctype='multipart/form-data'>
    <div>
        <label for='name'>Nom du personnage :</label>
        <input type='text' name='name' id='name' maxlength='20' required>
    </div>

    <div>
        <label for='hp'>Points de vie (HP) max : 150</label>
        <input type='number' name='hp' id='hp' min='10' max='150' value='100' required>
    </div>

    <div>
        <label for='atk'>Attaque (ATK) max : 150</label>
        <input type='number' name='atk' id='atk' min='10' max='150' value='10' required>
    </div>

    <div>
        <label for='def'>Défense (DEF) max : 150</label>
        <input type='number' name='def' id='def' min='10' max='150' value='10' required>
    </div>

    <div>
        <label for='image'>Image du personnage :</label>
        <input type='file' name='image' id='image' accept='image/*' required>
    </div>

    <button type='submit' name='addPerso'>Créer le personnage</button>
</form>

<a href='index.php?action=start' class='button'>Revenir à la sélection</a>

";
?>

<script>
        //controles de la musique
        function changeState(x){
    let btns = document.querySelectorAll(".btn");
    let audio = document.querySelector("#audio");
    for(let i = 0; i < btns.length; i++){
        btns[i].classList.remove("active");
    }
    btns[x].classList.add("active");

    if(x == 0){
        audio.play();
    }
    if(x == 1){
        audio.pause();
    }
    if(x == 2){
        audio.pause();
        audio.currentTime = 0;
    }
}
</script>
</body>
</html>

