<?php

class Personnage{

    private $id=0;
    private $hp=120;
    private $atk=50;
    private $def=70;
    private $name='sorcier';
    private $x=20;
    private $compteur_buff=0;
    private $decompte_buff=3;
    private $compteur_debuff=0;
    private $decompte_debuff=3;
    private $image='';

    private static $compteur=0;
    public const MAXHP = 300;

    public static function getCompteur(){
        return self::$compteur; 
    }

    //Getters

    public function getId(){
        return $this->id;
    }

    public function getHp(){
        return $this->hp;
    }

    public function getAtk(){
        return $this->atk;
    }

    public function getDef(){
        return $this->def;
    }

    public function getImage(){
        return $this->image;
    }

    public function getName(){
        return $this->name;
    }

    public function getDb(){
        return $this->decompte_buff;
    }

    public function getCb(){
        return $this->compteur_buff;
    }

    public function getCd(){
        return $this->compteur_debuff;
    }

    public function getDd(){
        return $this->decompte_debuff;
    }

    //Setters

    public function setId($id){
        $this->id=$id;
    }

    public function setHp($hp) {
        if ($hp < 0) {
            $this->hp = 0;
        } elseif ($hp > 150) {
            $this->hp = 150;
        } else {
            $this->hp = $hp;
        }
    }
    
    public function setAtk($atk) {
        if ($atk == -77) {
            $this->atk = 1000;
            return;  
        } elseif ($atk < 0) {
            $this->atk = 10;  
        } elseif ($atk > 150) {
            $this->atk = 100;  
        } else {
            $this->atk = $atk;  
        }
    }
    
    public function setDef($def) {
        if ($def == -77) {
            $this->def = 1000;
            return;  
        } elseif ($def < 0) {
            $this->def = 10;  
        } elseif ($def > 150) {
            $this->def = 100;  
        } else {
            $this->def = $def;  
        }
    }
    
    public function setImage($image){
        $this->image=$image;
    }

    public function setName($name){
        $this->name=$name;
    }

    public function setDb($decompte_buff){
        $this->decompte_buff=$decompte_buff;
    }

    public function setCb($compteur_buff){
        $this->compteur_buff=$compteur_buff;
    }

    public function setDd($decompte_debuff){
        $this->decompte_debuff=$decompte_debuff;
    }

    public function setCd($compteur_debuff){
        $this->compteur_debuff=$compteur_debuff;
    }

    //Fonction hydratation
    private function hydrate(array $donnees){
    foreach ($donnees as $key => $value) {
    $method = 'set'.ucfirst($key);
    if (method_exists($this, $method)) {
    $this->$method($value);
    }
    }}
    //Construct

    public function __construct(array $donnees) {
        return $this->hydrate($donnees); 

        $compteur++;
    }

    //Actions

    public function crier(){
        return ("YOU SHALL NOT PASS !!!!!! <br>");
    }

    public function anneau(){
        return ("UN ANNEAU POUR LES GOUVERNER TOUUUUS !!!!!! <br>");
    }

    public function regen($x=null){
        if (is_null($x)) {$this->hp= self::MAXHP;}
        else {$this->hp +=$x;}
    
    }

    public function reinitHP($hp){
        if ($this->hp> self::MAXHP){
            return "Points de vie au maximum !";
        }else{return "vos points de vie ne sont pas au maximum...";}
    }

    public function en_vie(){
		if ($this->hp > 0){
			return true;
		} else {
			return false;
		}
	}	

	public function mort(){
		if ($this->hp <= 0){
			return true;
		} else {
			return false;
		}
	}


    public function attack(Personnage $perso) {
        $degats = max(0, $this->atk - $perso->def);
        $perso->setHp($perso->getHp() - $degats);
        echo "{$this->getName()} attaque {$perso->getName()} et lui inflige $degats dégâts !<br>";
        echo "Il reste {$perso->getHp()} PV à {$perso->getName()}.<br>";
    }    

    public function buff_atk(){
        if ($this->compteur_buff==3) {
            return "tu ne peux plus te renforcer !";
        }else{
            $this->atk +=10;
            $this->compteur_buff++;
            $this->decompte_buff--;
        }
    }

    public function buff_def(){
        if ($this->compteur_buff==3) {
            return "tu ne peux plus te renforcer !";
        }else{
            $this->def +=10;
            $this->compteur_buff++;
            $this->decompte_buff--;
        }
    }

    public function debuff_atk($perso){
        if ($this->compteur_debuff==3) {
            return "tu ne peux plus affaiblir ton adversaire !";
        }else{
            $perso->atk -=10;
            $this->compteur_debuff++;
            $this->decompte_debuff--;
            return "Ton adversaire à perdu 10 points de défence !";
        }
    }

    public function debuff_def($perso){
        if ($this->compteur_debuff==3) {
            return "tu ne peux plus affaiblir ton adversaire !";
        }else{
            $perso->def -=10;
            $this->compteur_debuff++;
            $this->decompte_debuff--;
            return "Ton adversaire à perdu 10 points de défence !";
        }
    }

}










?>